part of 'category_list_view.dart';

class CategoryListItem extends StatelessWidget {
  final CategoryData categoryData;
  final ValueChanged<CategoryData?> onEdit;
  final ValueChanged<int?> onTap;
  final ValueChanged<int?> onTapSub;
  final double spacing;
  final List<int> selectParents;
  final List selectCategories;
  final List<int> selectSubs;
  final VoidCallback onSelect;
  final bool isSelected;
  final bool isLoading;

  const CategoryListItem({
    super.key,
    required this.categoryData,
    required this.onEdit,
    this.spacing = 1,
    required this.onTap,
    required this.selectParents,
    required this.selectSubs,
    required this.onTapSub,
    required this.onSelect,
    required this.isSelected,
    required this.isLoading,
    required this.selectCategories,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        return Padding(
          padding: EdgeInsets.only(bottom: spacing),
          child: Column(
            children: [
              categoryItem(
                type: 0,
                category: categoryData,
                isSelect: selectParents.contains(categoryData.id),
                isEmpty: categoryData.children?.isEmpty ?? true,
                constraints: constraints,
              ),
              if (selectParents.contains(categoryData.id))
                Padding(
                  padding: const EdgeInsets.only(bottom: 4),
                  child: Column(
                    children: List.generate(
                      categoryData.children?.length ?? 0,
                      (index) {
                        final subCategory = categoryData.children?[index];
                        return Column(
                          children: [
                            categoryItem(
                              type: 1,
                              category: subCategory,
                              isEmpty: categoryData.children?.isEmpty ?? true,
                              isSelect: selectSubs.contains(subCategory?.id),
                              isEnd: categoryData.children?.length == index + 1,
                              isFirst: index == 0,
                              constraints: constraints,
                            ),
                            if (selectSubs.contains(subCategory?.id))
                              Padding(
                                padding: const EdgeInsets.only(bottom: 4),
                                child: Column(
                                  children: List.generate(
                                    subCategory?.children?.length ?? 0,
                                    (index) {
                                      final childCategory =
                                          subCategory?.children?[index];
                                      return Column(
                                        children: [
                                          categoryItem(
                                            type: 2,
                                            category: childCategory,
                                            isEnd:
                                                subCategory?.children?.length ==
                                                index + 1,
                                            isFirst: index == 0,
                                            constraints: constraints,
                                          ),
                                        ],
                                      );
                                    },
                                  ),
                                ),
                              ),
                          ],
                        );
                      },
                    ),
                  ),
                ),
            ],
          ),
        );
      },
    );
  }

  Widget categoryItem({
    required CategoryData? category,
    required BoxConstraints constraints,
    bool isSelect = false,
    bool isEnd = false,
    bool isFirst = false,
    bool isEmpty = false,
    required int type,
  }) {
    return Container(
      decoration: BoxDecoration(
        color: isSelected ? Style.mainBack : Style.white,
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(type == 0 ? 12 : 0),
          topRight: Radius.circular(type == 0 ? 12 : 0),
          bottomLeft: Radius.circular(type == 0 || isSelect || isEnd ? 12 : 0),
          bottomRight: Radius.circular(
            !isSelect && isEnd || type == 0 && !isSelect ? 12 : 0,
          ),
        ),
      ),
      padding: EdgeInsets.symmetric(vertical: type == 0 ? 2 : 0),
      margin: EdgeInsets.only(left: type * 20),
      child: ButtonEffectAnimation(
        disabled: type != 2 && !isEmpty,
        onTap: () {
          if (type == 0) {
            onTap(category?.id);
          } else if (type == 1) {
            onTapSub(category?.id);
          }
        },
        child: Column(
          children: [
            if (isFirst) const Divider(height: 6),
            6.verticalSpace,
            //if(type == 1 || type == 2) 23.horizontalSpace,
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 18),
              child: Row(
                children: [
                  CustomCheckbox(isActive: isSelected, onTap: onSelect),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 18,
                    child: Text(
                      "${categoryData.id ?? 0}",
                      style: Style.interNormal(
                        size: 16,
                        color: Style.brandTitleDivider,
                      ),
                    ),
                  ),
                  8.horizontalSpace,
                  CommonImage(
                    url: category?.img,
                    height: 64,
                    width: constraints.maxWidth / 12,
                  ),
                  32.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 8,
                    child: Text(
                      AppHelpers.getTranslation(
                        category?.translation?.title ?? "--",
                      ),
                      style: Style.interNormal(
                        size: 16,
                        color: Style.brandTitleDivider,
                      ),
                    ),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 12,
                    child: Text(
                      AppHelpers.getTranslation(
                        AppHelpers.getTranslation(
                          (category?.active ?? false)
                              ? TrKeys.active
                              : TrKeys.inactive,
                        ),
                      ),
                      style: Style.interNormal(
                        size: 16,
                        color: Style.brandTitleDivider,
                      ),
                    ),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 16,
                    child: Text(
                      AppHelpers.getTranslation(
                        AppHelpers.getTranslation(
                          category?.translation?.locale ?? "",
                        ),
                      ),
                      style: Style.interNormal(
                        size: 16,
                        color: Style.brandTitleDivider,
                      ),
                    ),
                  ),
                  const Spacer(),
                  StatusButton(
                    status: category?.status ?? '',
                    verticalPadding: 4,
                    horizontalPadding: 12,
                  ),
                  const Spacer(),
                  if (category?.shopId != null &&
                      category?.shopId == LocalStorage.getUser()?.shop?.id)
                    Consumer(
                      builder: (context, ref, child) {
                        return Row(
                          children: [
                            MiniButton(
                              icon: Remix.edit_line,
                              onTap: () {
                                onEdit.call(category);
                              },
                            ),
                            10.horizontalSpace,
                            MiniButton(
                              icon: Remix.delete_bin_line,
                              onTap: () {
                                AppHelpers.showAlertDialog(
                                  context: context,
                                  child: DeleteDialog(
                                    success: () {
                                      ref
                                          .read(foodCategoriesProvider.notifier)
                                          .deleteCategory(
                                            context,
                                            category?.id,
                                          );
                                      Navigator.of(
                                        context,
                                        rootNavigator: true,
                                      ).pop();
                                    },
                                  ),
                                );
                              },
                            ),
                          ],
                        );
                      },
                    ),
                  8.horizontalSpace,
                  Row(
                    children: [
                      8.horizontalSpace,
                      if (type != 2 && !isEmpty)
                        Icon(
                          isSelect
                              ? Icons.keyboard_arrow_up
                              : Icons.keyboard_arrow_down,
                          size: 24,
                          color: isSelect ? Style.primary : Style.black,
                        ),
                    ],
                  ),
                ],
              ),
            ),
            if (type != 0 && !isEnd && !isSelect) const Divider(height: 6),
            if (isEnd) 4.verticalSpace,
          ],
        ),
      ),
    );
  }
}
